const router = require("express").Router();
const axios = require("axios");
const Request = require("../models/Request");

// Post Request
router.post("/", async (req, res) => {
    const { url, method, headers, body } = req.body;

    try {
        const apiRes = await axios({
            url,
            method,
            headers,
            data: body
        });

        await Request.create({
            url,
            method,
            headers,
            body,
            response: apiRes.data,
            status: apiRes.status
        });

        res.json({
            status: apiRes.status,
            response: apiRes.data
        });
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
});

// Get History
router.get("/history", async (req, res) => {
    try {
        const requests = await Request.find().sort({ createdAt: -1 });
        res.json(requests);
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
});

// Delete History
router.delete("/history/:id", async (req, res) => {
    try {
        await Request.findByIdAndDelete(req.params.id);
        res.json({ message: "Request deleted successfully" });
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
});

module.exports = router;